<section class="card">
    <div class="card-body">
        <form method="post" action="/admin" class="mb-0">
            <?php echo csrf_field(); ?>

            <div class="row">


                <div class="col-md-4">
                    <div class="form-group">
                        <label class="input-label">Start Date </label>
                        <div class="input-group">
                            <input type="date" id="from" class="text-center form-control" name="from" value="  " placeholder="Start Date" required>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label class="input-label">End Date </label>
                        <div class="input-group">
                            <input type="date" id="to" class="text-center form-control" name="to" value=" " placeholder="End Date" required>
                        </div>
                    </div>
                </div>


                <div class="col-md-4">
                    <div class="form-group mt-1">
                        <label class="input-label mb-4"> </label>
                        <input type="submit" class="text-center btn btn-primary w-100" value="Show Results">
                    </div>
                </div>
            </div>
        </form>
    </div>
</section>
<?php if($from): ?>
<p class="text-danger">Search Date <?php echo e($from); ?> to <?php echo e($to); ?> </p>
<?php endif; ?>


<section class="section">


    <div class="row">

        <div class="col-lg-3 col-md-6 col-sm-6 col-12">
            <a href="<?php echo e(getAdminPanelUrl()); ?>/instructors" class="card card-statistic-1">
                <div class="card-icon bg-primary">
                    <i class="fas fa-user"></i>
                </div>
                <div class="card-wrap">
                    <div class="card-header">
                        <h4><?php echo e(trans('admin/main.total_instructors')); ?></h4>
                    </div>
                    <div class="card-body">
                        <?php echo e($instructorCount); ?>

                    </div>
                </div>
            </a>
        </div>

        <div class="col-lg-3 col-md-6 col-sm-6 col-12">
            <a href="<?php echo e(getAdminPanelUrl()); ?>/students" class="card card-statistic-1">
                <div class="card-icon bg-primary">
                    <i class="fas fa-user"></i>
                </div>
                <div class="card-wrap">
                    <div class="card-header">
                        <h4><?php echo e(trans('admin/main.total_students')); ?></h4>
                    </div>
                    <div class="card-body">
                        <?php echo e($studentCount); ?>

                    </div>
                </div>
            </a>
        </div>
        <div class="col-lg-3 col-md-6 col-sm-6 col-12">
            <a href="<?php echo e(getAdminPanelUrl()); ?>/webinars" class="card card-statistic-1">
                <div class="card-icon bg-primary">
                    <i class="fas fa-file-video"></i>
                </div>
                <div class="card-wrap">
                    <div class="card-header">
                        <h4><?php echo e(trans('admin/main.courses')); ?></h4>
                    </div>
                    <div class="card-body">
                        <?php echo e($courseCount); ?>

                    </div>
                </div>
            </a>
        </div>
        <div class="col-lg-3 col-md-6 col-sm-6 col-12">
            <a href="<?php echo e(getAdminPanelUrl()); ?>/webinars" class="card card-statistic-1">
                <div class="card-icon bg-primary">
                    <i class="fas fa-file-video"></i>
                </div>
                <div class="card-wrap">
                    <div class="card-header">
                        <h4><?php echo e(trans('Live Courses')); ?></h4>
                    </div>
                    <div class="card-body">
                        <?php echo e($liveCount); ?>

                    </div>
                </div>
            </a>
        </div>
        <div class="col-lg-3 col-md-6 col-sm-6 col-12">
            <a href="<?php echo e(getAdminPanelUrl()); ?>/webinars" class="card card-statistic-1">
                <div class="card-icon bg-primary">
                    <i class="fas fa-file-video"></i>
                </div>
                <div class="card-wrap">
                    <div class="card-header">
                        <h4><?php echo e(trans('Video Courses')); ?></h4>
                    </div>
                    <div class="card-body">
                        <?php echo e($videoCount); ?>

                    </div>
                </div>
            </a>
        </div>
        <div class="col-lg-3 col-md-6 col-sm-6 col-12">
            <a href="<?php echo e(getAdminPanelUrl()); ?>/quizzes" class="card card-statistic-1">
                <div class="card-icon bg-primary">
                    <i class="fas fa-file-alt"></i>
                </div>
                <div class="card-wrap">
                    <div class="card-header">
                        <h4><?php echo e(trans('admin/main.total_quizzes')); ?></h4>
                    </div>
                    <div class="card-body">
                        <?php echo e($quizCount); ?>

                    </div>
                </div>
            </a>
        </div>
        <div class="col-lg-3 col-md-6 col-sm-6 col-12">
            <a href="<?php echo e(getAdminPanelUrl()); ?>/blog" class="card card-statistic-1">
                <div class="card-icon bg-primary">
                    <i class="fas fa-file-alt"></i>
                </div>
                <div class="card-wrap">
                    <div class="card-header">
                        <h4><?php echo e(trans('Blogs')); ?></h4>
                    </div>
                    <div class="card-body">
                        <?php echo e($blogCount); ?>

                    </div>
                </div>
            </a>
        </div>
        <div class="col-lg-3 col-md-6 col-sm-6 col-12">
            <a href="<?php echo e(getAdminPanelUrl()); ?>/forums" class="card card-statistic-1">
                <div class="card-icon bg-primary">
                    <i class="fas fa-file-alt"></i>
                </div>
                <div class="card-wrap">
                    <div class="card-header">
                        <h4><?php echo e(trans('Forum Topic')); ?></h4>
                    </div>
                    <div class="card-body">
                        <?php echo e($forumCount); ?>

                    </div>
                </div>
            </a>
        </div>
    </div>


    <div class="row">

        <div class="col-lg-4 col-md-12 col-12 col-sm-12">
            <div class="card">
                <div class="card-header">
                    <h4><?php echo e(trans('admin/main.user_type_statistics')); ?></h4>
                </div>
                <div class="card-body">
                    <canvas id="userTypeStatisticsChart" height="490"></canvas>
                </div>
            </div>
        </div>
        <div class="col-lg-4 col-md-12 col-12 col-sm-12">
            <div class="card">
                <div class="card-header">
                    <h4><?php echo e(trans('admin/main.user_statistics')); ?></h4>
                </div>
                <div class="card-body">
                    <canvas id="userStatusStatisticsChart" height="490"></canvas>
                </div>
            </div>
        </div>
        <div class="col-lg-4 col-md-12 col-12 col-sm-12">
            <div class="card">
                <div class="card-header">
                    <h4><?php echo e(trans('admin/main.classes_statistics')); ?></h4>
                </div>
                <div class="card-body">
                    <canvas id="classesStatisticsChart" height="490"></canvas>
                </div>
            </div>
        </div>
    </div>



    <div class="row">
            <div class="col-lg-12 col-md-12 col-12 col-sm-12">
                <div class="card">
                    <div class="card-header">
                        <h4><?php echo e(trans('admin/main.new_registration_statistics')); ?></h4>
                        <div class="card-header-action">
                            <div class="btn-group">
                                
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-12">
                                <div class="position-relative">
                                    <canvas id="usersStatisticsChart"></canvas>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    <div class="row">
        <div class="col-lg-12 col-md-12 col-12 col-sm-12">
            <div class="card">
                <div class="card-header">
                    <h4><?php echo e(trans('admin/main.new_registration_statistics')); ?></h4>
                    <div class="card-header-action">
                        <div class="btn-group">
                            
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-12">
                            <div class="position-relative">
                                <canvas id="myChart" style="width:100%;"></canvas>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>

    <div class="row">
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h4><?php echo e(trans('admin/main.top_classes')); ?></h4>
                    <div class="card-header-action">
                        <a href="<?php echo e(getAdminPanelUrl()); ?>/webinars?type=course&sort=sales_desc"
                           class="btn btn-primary"><?php echo e(trans('admin/main.view_more')); ?><i class="fas fa-chevron-right"></i></a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive text-center">
                        <table class="table table-striped font-14">

                            <tr>
                                <th>#</th>
                                <th class="text-left"><?php echo e(trans('admin/main.name')); ?></th>
                                <th><?php echo e(trans('admin/main.enrolled')); ?></th>

                            </tr>

                            <?php $__currentLoopData = $getTopSellingClasses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $getTopSellingClass): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($getTopSellingClass->id); ?></td>
                                    <td>
                                        <a href="<?php echo e($getTopSellingClass->getUrl()); ?>" target="_blank"
                                           class="media-body text-left">
                                            <div><?php echo e($getTopSellingClass->title); ?></div>
                                            <div
                                                class="text-primary text-small font-600-bold"><?php echo e(trans('webinars.'.$getTopSellingClass->type)); ?></div>
                                        </a>
                                    </td>
                                    <td><?php echo e($getTopSellingClass->sales_count); ?></td>

                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h4><?php echo e(trans('admin/main.top_instructors')); ?></h4>
                    <div class="card-header-action">
                        <a href="<?php echo e(getAdminPanelUrl()); ?>/instructors?sort=sales_classes_desc"
                           class="btn btn-sm btn-primary"><?php echo e(trans('admin/main.view_more')); ?><i
                                class="fas fa-chevron-right"></i></a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive text-center">
                        <table class="table table-striped font-14">
                            <tr>
                                <th><?php echo e(trans('admin/main.id')); ?></th>
                                <th class="text-left"><?php echo e(trans('admin/main.name')); ?></th>
                                <th><?php echo e(trans('admin/main.classes_durations')); ?></th>
                                <th><?php echo e(trans('admin/main.enrolled')); ?></th>


                            </tr>

                            <?php $__currentLoopData = $getTopSellingTeachers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $getTopSellingTeacher): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($getTopSellingTeacher->id); ?></td>
                                    <td class="text-left"><?php echo e($getTopSellingTeacher->full_name); ?></td>
                                    <td><?php echo e(convertMinutesToHourAndMinute($getTopSellingTeacher->classes_durations)); ?>

                                        Hours
                                    </td>
                                    <td><?php echo e($getTopSellingTeacher->sales_count); ?></td>

                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </table>
                    </div>
                </div>
            </div>
        </div>

    </div>
    <div class="row">

        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h4><?php echo e(trans('admin/main.most_active_students')); ?></h4>
                    <div class="card-header-action">
                        <a href="<?php echo e(getAdminPanelUrl()); ?>/students?sort=register_desc"
                           class="btn btn-sm btn-primary"><?php echo e(trans('admin/main.view_more')); ?><i
                                class="fas fa-chevron-right"></i></a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive text-center">
                        <table class="table table-striped font-14">
                            <tr>
                                <th>#</th>
                                <th class="text-left"><?php echo e(trans('admin/main.name')); ?></th>
                                <th><?php echo e(trans('admin/main.enrolled_classes')); ?></th>

                            </tr>
                            <?php $__currentLoopData = $getMostActiveStudents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $getMostActiveStudent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($getMostActiveStudent->id); ?></td>
                                    <td class="text-left"><?php echo e($getMostActiveStudent->full_name); ?></td>
                                    <td><?php echo e($getMostActiveStudent->purchased_classes); ?></td>

                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </table>
                    </div>
                </div>
            </div>
        </div>

    </div>




</section>
<?php /**PATH /home/maharass.com/public_html/resources/views/admin/undp_dashboard.blade.php ENDPATH**/ ?>