<?php
    if (empty($authUser) and auth()->check()) {
        $authUser = auth()->user();
    }

    $navBtnUrl = null;
    $navBtnText = null;

    if(request()->is('forums*')) {
        $navBtnUrl = '/forums/create-topic';
        $navBtnText = trans('update.create_new_topic');
    } else {
        $navbarButton = getNavbarButton(!empty($authUser) ? $authUser->role_id : null, empty($authUser));

        if (!empty($navbarButton)) {
            $navBtnUrl = $navbarButton->url;
            $navBtnText = $navbarButton->title;
        }
    }
?>
<?php
    $userLanguages = !empty($generalSettings['site_language']) ? [$generalSettings['site_language'] => getLanguages($generalSettings['site_language'])] : [];

    if (!empty($generalSettings['user_languages']) and is_array($generalSettings['user_languages'])) {
        $userLanguages = getLanguages($generalSettings['user_languages']);
    }

    $localLanguage = [];

    foreach($userLanguages as $key => $userLanguage) {
        $localLanguage[localeToCountryCode($key)] = $userLanguage;
    }

?>

<div id="navbarVacuum"></div>
<nav id="navbar" class="navbar navbar-expand-lg navbar-light">
    <div class="<?php echo e((!empty($isPanel) and $isPanel) ? 'container-fluid' : 'container'); ?>">
        <div class="d-flex align-items-center justify-content-between w-100">

            <a class="navbar-brand navbar-order d-flex align-items-center justify-content-center mr-0 <?php echo e((empty($navBtnUrl) and empty($navBtnText)) ? 'ml-auto' : ''); ?>"
               href="/">
                <?php if(!empty($generalSettings['logo'])): ?>
                    <img src="<?php echo e($generalSettings['logo']); ?>" class="img-cover" alt="site logo">
                <?php endif; ?>
            </a>

            <button class="navbar-toggler navbar-order" type="button" id="navbarToggle">
                <span class="navbar-toggler-icon"></span>
            </button>

            <div class="mx-lg-30 d-none d-lg-flex flex-grow-1 navbar-toggle-content " id="navbarContent">
                <div class="navbar-toggle-header text-right d-lg-none">
                    <button class="btn-transparent" id="navbarClose">
                        <i data-feather="x" width="32" height="32"></i>
                    </button>
                </div>

                <ul class="navbar-nav mr-auto d-flex align-items-center">
                    <?php if(!empty($categories) and count($categories)): ?>
                        <li class="mr-lg-25">
                            <div class="menu-category">
                                <ul>
                                    <li class="cursor-pointer user-select-none d-flex xs-categories-toggle">
                                        <i data-feather="grid" width="20" height="20"
                                           class=" d-none d-lg-block"></i>
                                        

                                        <ul class="cat-dropdown-menu">
                                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <li>
                                                    <a href="<?php echo e($category->getUrl()); ?>"
                                                       class="<?php echo e((!empty($category->subCategories) and count($category->subCategories)) ? 'js-has-subcategory' : ''); ?>">
                                                        <div class="d-flex align-items-center">
                                                            <img src="<?php echo e($category->icon); ?>"
                                                                 class="cat-dropdown-menu-icon mr-10"
                                                                 alt="<?php echo e($category->title); ?> icon">
                                                            <?php echo e($category->title); ?>

                                                        </div>

                                                        <?php if(!empty($category->subCategories) and count($category->subCategories)): ?>
                                                            <i data-feather="chevron-right" width="20" height="20"
                                                               class="d-none d-lg-inline-block ml-10"></i>
                                                            <i data-feather="chevron-down" width="20" height="20"
                                                               class="d-inline-block d-lg-none"></i>
                                                        <?php endif; ?>
                                                    </a>

                                                    <?php if(!empty($category->subCategories) and count($category->subCategories)): ?>
                                                        <ul class="sub-menu" data-simplebar
                                                            <?php if((!empty($isRtl) and $isRtl)): ?> data-simplebar-direction="rtl" <?php endif; ?>>
                                                            <?php $__currentLoopData = $category->subCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subCategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <li>
                                                                    <a href="<?php echo e($subCategory->getUrl()); ?>">
                                                                        <?php if(!empty($subCategory->icon)): ?>
                                                                            <img src="<?php echo e($subCategory->icon); ?>"
                                                                                 class="cat-dropdown-menu-icon mr-10"
                                                                                 alt="<?php echo e($subCategory->title); ?> icon">
                                                                        <?php endif; ?>

                                                                        <?php echo e($subCategory->title); ?>

                                                                    </a>
                                                                </li>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </ul>
                                                    <?php endif; ?>
                                                </li>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </ul>
                                    </li>
                                </ul>
                            </div>
                        </li>
                    <?php endif; ?>

                    <?php if(!empty($navbarPages) and count($navbarPages)): ?>
                        <?php $__currentLoopData = $navbarPages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $navbarPage): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="nav-item">
                                <a class="nav-link" href="<?php echo e($navbarPage['link']); ?>"><?php echo e($navbarPage['title']); ?></a>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>

                    <li>
                        <?php if(!empty($authUser)): ?>

                            <div class="custom-dropdown navbar-auth-user-dropdown position-relative ml-50">
                                <div
                                    class="custom-dropdown-toggle d-flex align-items-center navbar-user cursor-pointer">
                                    <img src="<?php echo e($authUser->getAvatar()); ?>" width="25px" class="rounded-circle"
                                         alt="<?php echo e($authUser->full_name); ?>">
                                    <span class="font-16 user-name ml-10 text-dark-blue font-14"><?php echo e($authUser->full_name); ?> </span>
                                    <img src="/assets/default/img/chevron-down.svg" width="15px" class="rounded-circle"
                                         alt="dropdown-icon">
                                </div>

                                <div class="custom-dropdown-body pb-10">

                                    <div
                                        class="dropdown-user-avatar d-flex align-items-center p-15 m-15 mb-10 rounded-sm border">
                                        <div class="size-40 rounded-circle position-relative">
                                            <img src="<?php echo e($authUser->getAvatar()); ?>" width="25px"
                                                 class="img-cover rounded-circle" alt="<?php echo e($authUser->full_name); ?>">


                                        </div>

                                        <div class="ml-5">
                                            <div
                                                class="font-14 font-weight-bold text-secondary"><?php echo e($authUser->full_name); ?></div>
                                            <span class="mt-5 text-gray font-12"><?php echo e($authUser->role->caption); ?></span>
                                        </div>
                                    </div>

                                    <ul class="my-8">
                                        <?php if($authUser->isAdmin()): ?>
                                            <li class="navbar-auth-user-dropdown-item">
                                                <a href="<?php echo e(getAdminPanelUrl()); ?>"
                                                   class="d-flex align-items-center w-100 px-15 py-10 text-gray font-14 bg-transparent">
                                                    <img src="/assets/default/img/icons/user_menu/dashboard.svg"
                                                         class="icons">
                                                    <span class="ml-5"><?php echo e(trans('panel.dashboard')); ?></span>
                                                </a>
                                            </li>

                                            <li class="navbar-auth-user-dropdown-item">
                                                <a href="<?php echo e(getAdminPanelUrl("/settings")); ?>"
                                                   class="d-flex align-items-center w-100 px-15 py-10 text-gray font-14 bg-transparent">
                                                    <img src="/assets/default/img/icons/user_menu/settings.svg"
                                                         class="icons">
                                                    <span class="ml-5"><?php echo e(trans('panel.settings')); ?></span>
                                                </a>
                                            </li>
                                        <?php else: ?>
                                            <li class="navbar-auth-user-dropdown-item">
                                                <a href="/panel"
                                                   class="d-flex align-items-center w-100 px-15 py-10 text-gray font-14 bg-transparent">
                                                    <img src="/assets/default/img/icons/user_menu/dashboard.svg"
                                                         class="icons">
                                                    <span class="ml-5"><?php echo e(trans('panel.dashboard')); ?></span>
                                                </a>
                                            </li>


                                            <li class="navbar-auth-user-dropdown-item">
                                                <a href="<?php echo e(($authUser->isUser()) ? '/panel/webinars/purchases' : '/panel/webinars'); ?>"
                                                   class="d-flex align-items-center w-100 px-15 py-10 text-gray font-14 bg-transparent">
                                                    <img src="/assets/default/img/icons/user_menu/my_courses.svg"
                                                         class="icons">
                                                    <span class="ml-5"><?php echo e(trans('update.my_courses')); ?></span>
                                                </a>
                                            </li>

                                          

                                            <li class="navbar-auth-user-dropdown-item">
                                                <a href="/panel/support"
                                                   class="d-flex align-items-center w-100 px-15 py-10 text-gray font-14 bg-transparent">
                                                    <img src="/assets/default/img/icons/user_menu/support.svg"
                                                         class="icons">
                                                    <span class="ml-5"><?php echo e(trans('panel.support')); ?></span>
                                                </a>
                                            </li>

                                            <?php if(!$authUser->isUser()): ?>
                                                <li class="navbar-auth-user-dropdown-item">
                                                    <a href="<?php echo e($authUser->getProfileUrl()); ?>"
                                                       class="d-flex align-items-center w-100 px-15 py-10 text-gray font-14 bg-transparent">
                                                        <img src="/assets/default/img/icons/user_menu/profile.svg"
                                                             class="icons">
                                                        <span class="ml-5"><?php echo e(trans('public.profile')); ?></span>
                                                    </a>
                                                </li>
                                            <?php endif; ?>

                                            <li class="navbar-auth-user-dropdown-item">
                                                <a href="/panel/setting"
                                                   class="d-flex align-items-center w-100 px-15 py-10 text-gray font-14 bg-transparent">
                                                    <img src="/assets/default/img/icons/user_menu/settings.svg"
                                                         class="icons">
                                                    <span class="ml-5"><?php echo e(trans('panel.settings')); ?></span>
                                                </a>
                                            </li>
                                        <?php endif; ?>

                                        <li class="navbar-auth-user-dropdown-item">
                                            <a href="/logout"
                                               class="d-flex align-items-center w-100 px-15 py-10 text-danger font-14 bg-transparent">
                                                <img src="/assets/default/img/icons/user_menu/logout.svg" class="icons">
                                                <span class="ml-5"><?php echo e(trans('auth.logout')); ?></span>
                                            </a>
                                        </li>

                                    </ul>

                                </div>
                            </div>
                        <?php else: ?>
                            <div class="d-flex align-items-center ml-md-50">
                                <a href="/login"
                                   class="py-5 px-10 mr-10 text-dark-blue font-14"><?php echo e(trans('auth.login')); ?></a>
                                <a href="/register"
                                   class="py-5 px-10 text-dark-blue font-14"><?php echo e(trans('auth.register')); ?></a>
                            </div>
                        <?php endif; ?>
                    </li>
                    <li>
                        <?php echo $__env->make(getTemplate().'.includes.shopping-cart-dropdwon', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </li>

                    <li>

                        <div class="custom-dropdown navbar-auth-user-dropdown position-relative ml-50">
                            <div class="custom-dropdown-toggle d-flex align-items-center navbar-user cursor-pointer">
                                <button
                                    class="btn-transparent d-flex align-items-center justify-content-center search-icon">
                                    <i id="search-icon" data-feather="search" width="20" height="20" class="mr-10"></i>
                                </button>
                            </div>

                            <div class="custom-dropdown-body pb-10">

                                <form action="/search" method="get" style="margin-left: 40px; padding-top: 15px"
                                      class="form-inline my-2 my-lg-0  navbar-search position-relative"
                                      id="form-design">
                                    <input class="form-control mr-5 rounded" type="text" name="search"
                                           placeholder="<?php echo e(trans('navbar.search_anything')); ?>" aria-label="Search">

                                    <button type="submit"
                                            class="btn-transparent d-flex align-items-center justify-content-center search-icon">
                                        <i data-feather="search" width="20" height="20" class="mr-10"></i>
                                    </button>
                                </form>
                            </div>
                        </div>
                    </li>


                </ul>
            </div>


            <div class="nav-icons-or-start-live navbar-order d-flex align-items-center justify-content-end">
                <?php if(!empty($localLanguage) and count($localLanguage) > 1): ?>
                    <form action="/locale" method="post" class="mr-15 mx-md-20">
                        <?php echo e(csrf_field()); ?>


                        <input type="hidden" name="locale">

                        <?php if(!empty($previousUrl)): ?>
                            <input type="hidden" name="previous_url" value="<?php echo e($previousUrl); ?>">
                        <?php endif; ?>

                        <div class="language-select">
                            <div id="localItems"
                                 data-selected-country="<?php echo e(localeToCountryCode(mb_strtoupper(app()->getLocale()))); ?>"
                                 data-countries='<?php echo e(json_encode($localLanguage)); ?>'
                            ></div>
                        </div>
                    </form>
                <?php else: ?>
                    <div class="mr-15 mx-md-20"></div>
                <?php endif; ?>

                
            </div>
        </div>
    </div>
</nav>

<?php $__env->startPush('scripts_bottom'); ?>

    <script src="/assets/default/js/parts/navbar.min.js"></script>
    <link href="/assets/default/vendors/flagstrap/css/flags.css" rel="stylesheet">
    <script src="/assets/default/vendors/flagstrap/js/jquery.flagstrap.min.js"></script>
    <script src="/assets/default/js/parts/top_nav_flags.min.js"></script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/maharass.com/public_html/resources/views/web/default/includes/navbar.blade.php ENDPATH**/ ?>