function _createForOfIteratorHelper(o, allowArrayLike) { var it; if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = o[Symbol.iterator](); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

(function ($) {
  "use strict";

  if (jQuery().summernote) {
    makeSummernote($('#summernote'), 400);
  }

  $('body').on('click', '#sendForReview', function (e) {
    $(this).addClass('loadingbar primary').prop('disabled', true);
    e.preventDefault();
    $('#forDraft').val(0);
    $('#upcomingCourseForm').trigger('submit');
  });
  $('body').on('click', '#saveAsDraft', function (e) {
    $(this).addClass('loadingbar primary').prop('disabled', true);
    e.preventDefault();
    $('#forDraft').val(1);
    $('#upcomingCourseForm').trigger('submit');
  });
  $('body').on('click', '#getNextStep', function (e) {
    $(this).addClass('loadingbar primary').prop('disabled', true);
    e.preventDefault();
    $('#forDraft').val(1);
    $('#getNext').val(1);
    $('#upcomingCourseForm').trigger('submit');
  });
  $('body').on('click', '.js-get-next-step', function (e) {
    e.preventDefault();

    if (!$(this).hasClass('active')) {
      $(this).addClass('loadingbar primary').prop('disabled', true);
      var step = $(this).attr('data-step');
      $('#getStep').val(step);
      $('#forDraft').val(1);
      $('#getNext').val(1);
      $('#upcomingCourseForm').trigger('submit');
    }
  });

  function handleGetFiltersTitleFromTranslations(translations, defaultLocale) {
    var title = null;

    if (Object.keys(translations).length) {
      Object.keys(translations).forEach(function (key) {
        var translation = translations[key];

        if (translation.locale === defaultLocale) {
          title = translation.title;
        }
      });

      if (!title) {
        title = translations[0].title;
      }
    }

    return title;
  }

  $('body').on('change', '#categories', function (e) {
    e.preventDefault();
    var category_id = this.value;
    $.get('/panel/filters/get-by-category-id/' + category_id, function (result) {
      if (result && typeof result.filters !== "undefined" && result.filters.length) {
        var defaultLocale = result.defaultLocale;
        var html = '';
        Object.keys(result.filters).forEach(function (key) {
          var filter = result.filters[key];
          var options = [];

          if (filter.options.length) {
            options = filter.options;
          }

          var filterTitle = filter.title;

          if (!filterTitle && filter.translations) {
            filterTitle = handleGetFiltersTitleFromTranslations(filter.translations, defaultLocale);
          }

          html += '<div class="col-12 col-md-3">\n' + '<div class="webinar-category-filters">\n' + '<strong class="category-filter-title d-block">' + filterTitle + '</strong>\n' + '<div class="py-10"></div>\n' + '\n';

          if (options.length) {
            Object.keys(options).forEach(function (index) {
              var option = options[index];
              var optionTitle = option.title;

              if (!optionTitle && option.translations) {
                optionTitle = handleGetFiltersTitleFromTranslations(option.translations, defaultLocale);
              }

              html += '<div class="form-group mt-20 d-flex align-items-center justify-content-between">\n' + '<label class="cursor-pointer" for="filterOption' + option.id + '">' + optionTitle + '</label>\n' + '<div class="custom-control custom-checkbox">\n' + '<input type="checkbox" name="filters[]" value="' + option.id + '" class="custom-control-input" id="filterOption' + option.id + '">\n' + '<label class="custom-control-label" for="filterOption' + option.id + '"></label>\n' + '</div>\n' + '</div>\n';
            });
          }

          html += '</div></div>';
        });
        $('#categoriesFiltersContainer').removeClass('d-none');
        $('#categoriesFiltersCard').html(html);
      } else {
        $('#categoriesFiltersContainer').addClass('d-none');
        $('#categoriesFiltersCard').html('');
      }
    });
  });
  $('body').on('click', '.cancel-accordion', function (e) {
    e.preventDefault();
    $(this).closest('.accordion-row').remove();
  });

  function randomString() {
    var text = "";
    var possible = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";

    for (var i = 0; i < 5; i++) {
      text += possible.charAt(Math.floor(Math.random() * possible.length));
    }

    return text;
  }
  /*
  *
  * */


  window.handleWebinarItemForm = function (form, $this) {
    var data = serializeObjectByTag(form);
    var action = form.attr('data-action');
    $this.addClass('loadingbar primary').prop('disabled', true);
    form.find('input').removeClass('is-invalid');
    form.find('textarea').removeClass('is-invalid');
    $.post(action, data, function (result) {
      if (result && result.code === 200) {
        //window.location.reload();
        Swal.fire({
          icon: 'success',
          html: '<h3 class="font-20 text-center text-dark-blue py-25">' + saveSuccessLang + '</h3>',
          showConfirmButton: false,
          width: '25rem'
        });
        setTimeout(function () {
          window.location.reload();
        }, 500);
      }
    }).fail(function (err) {
      $this.removeClass('loadingbar primary').prop('disabled', false);
      var errors = err.responseJSON;

      if (errors && errors.status === 'zoom_token_invalid') {
        Swal.fire({
          icon: 'error',
          html: '<h3 class="font-20 text-center text-dark-blue py-25">' + errors.zoom_error_msg + '</h3>',
          showConfirmButton: false,
          width: '25rem'
        });
      }

      if (errors && errors.errors) {
        Object.keys(errors.errors).forEach(function (key) {
          var error = errors.errors[key];
          var element = form.find('.js-ajax-' + key);
          element.addClass('is-invalid');
          element.parent().find('.invalid-feedback').text(error[0]);
        });
      }
    });
  };
  /**
   * add webinar FAQ
   * */


  $('body').on('click', '#upcomingCourseAddFAQ', function (e) {
    e.preventDefault();
    var key = randomString();
    var add_faq = $('#newFaqForm').html();
    add_faq = add_faq.replaceAll('record', key);
    $('#faqsAccordion').prepend(add_faq);
    feather.replace();
  });
  $('body').on('click', '.js-save-faq', function (e) {
    e.preventDefault();
    var $this = $(this);
    var form = $this.closest('.faq-form');
    handleWebinarItemForm(form, $this);
  });
  $('body').on('click', '#add_new_learning_materials', function (e) {
    e.preventDefault();
    var key = randomString();
    var add_faq = $('#new_learning_materials_html').html();
    add_faq = add_faq.replaceAll('record', key);
    $('#learning_materials_accordion').prepend(add_faq);
    feather.replace();
  });
  $('body').on('click', '#add_new_company_logos', function (e) {
    e.preventDefault();
    var key = randomString();
    var add_faq = $('#new_company_logos_html').html();
    add_faq = add_faq.replaceAll('record', key);
    $('#company_logos_accordion').prepend(add_faq);
    feather.replace();
  });
  $('body').on('click', '#add_new_requirements', function (e) {
    e.preventDefault();
    var key = randomString();
    var add_faq = $('#new_requirements_html').html();
    add_faq = add_faq.replaceAll('record', key);
    $('#requirements_accordion').prepend(add_faq);
    feather.replace();
  });
  $('body').on('click', '.js-save-extra_description', function (e) {
    e.preventDefault();
    var $this = $(this);
    var form = $this.closest('.extra_description-form');
    handleWebinarItemForm(form, $this);
  });
  $(document).ready(function () {
    var style = getComputedStyle(document.body);
    var primaryColor = style.getPropertyValue('--primary');

    function updateToDatabase(table, idString) {
      $.post('/panel/upcoming_courses/order-items', {
        table: table,
        items: idString
      }, function (result) {
        if (result && result.title && result.msg) {
          $.toast({
            heading: result.title,
            text: result.msg,
            bgColor: primaryColor,
            textColor: 'white',
            hideAfter: 10000,
            position: 'bottom-right',
            icon: 'success'
          });
        }
      });
    }

    function setSortable(target) {
      if (target.length) {
        target.sortable({
          group: 'no-drop',
          handle: '.move-icon',
          axis: "y",
          update: function update(e, ui) {
            var sortData = target.sortable('toArray', {
              attribute: 'data-id'
            });
            var table = e.target.getAttribute('data-order-table');
            updateToDatabase(table, sortData.join(','));
          }
        });
      }
    }

    var items = [];
    var draggableContentLists = $('.draggable-content-lists');

    if (draggableContentLists.length) {
      var _iterator = _createForOfIteratorHelper(draggableContentLists),
          _step;

      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var item = _step.value;
          items.push($(item).attr('data-drag-class'));
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }
    }

    if (items.length) {
      var _iterator2 = _createForOfIteratorHelper(items),
          _step2;

      try {
        for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
          var _item = _step2.value;
          var tag = $('.' + _item);

          if (tag.length) {
            setSortable(tag);
          }
        }
      } catch (err) {
        _iterator2.e(err);
      } finally {
        _iterator2.f();
      }
    }
  });
  $('body').on('change', '.js-video-demo-source', function (e) {
    e.preventDefault();
    var value = $(this).val();
    var $filePathUploadButton = $('.js-video-demo-path-input .js-video-demo-path-upload');
    var $filePathLinkButton = $('.js-video-demo-path-input .js-video-demo-path-links');
    var $filePathInput = $('.js-video-demo-path-input input');
    $filePathUploadButton.addClass('d-none');
    $filePathLinkButton.addClass('d-none');

    if (value === 'upload') {
      $filePathUploadButton.removeClass('d-none');
    } else {
      $filePathLinkButton.removeClass('d-none');
    }

    if (videoDemoPathPlaceHolderBySource) {
      $filePathInput.attr('placeholder', videoDemoPathPlaceHolderBySource[value]);
    }
  });
  $('body').on('change', '.js-upcoming-course-content-locale', function (e) {
    e.preventDefault();
    var $this = $(this);
    var $form = $(this).closest('.js-content-form');
    var locale = $this.val();
    var upcomingId = $this.attr('data-upcoming-course-id');
    var item_id = $this.attr('data-id');
    var relation = $this.attr('data-relation');
    var fields = $this.attr('data-fields');
    fields = fields.split(',');
    $this.addClass('loadingbar gray');
    var path = '/panel/upcoming_courses/' + upcomingId + '/getContentItemByLocale';
    var data = {
      item_id: item_id,
      locale: locale,
      relation: relation
    };
    $.post(path, data, function (result) {
      if (result && result.item) {
        var item = result.item;
        Object.keys(item).forEach(function (key) {
          var value = item[key];

          if ($.inArray(key, fields) !== -1) {
            var element = $form.find('.js-ajax-' + key);
            element.val(value);
          }
        });
        $this.removeClass('loadingbar gray');
      }
    }).fail(function (err) {
      $this.removeClass('loadingbar gray');
    });
  });
})(jQuery);
