
@extends('admin.layouts.app')

@push('libraries_top')

@endpush


@section('content')
    <section class="section">
        <div class="section-header">
            <h1>Course Bundles</h1>
            <div class="section-header-breadcrumb">
                <div class="breadcrumb-item active"><a href="/admin">Dashboard</a>
                </div>
                <div class="breadcrumb-item">Courses</div>

                <div class="breadcrumb-item">Course Bundles</div>
            </div>
        </div>

        <div class="section-body">

            <div class="row">
                <div class="col-lg-3 col-md-6 col-sm-6 col-12">
                    <div class="card card-statistic-1">
                        <div class="card-icon bg-primary">
                            <i class="fas fa-cube"></i>
                        </div>
                        <div class="card-wrap">
                            <div class="card-header">
                                <h4>Total Course Bundles</h4>
                            </div>
                            <div class="card-body">
                                3
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6 col-sm-6 col-12">
                    <div class="card card-statistic-1">
                        <div class="card-icon bg-warning">
                            <i class="fas fa-eye"></i>
                        </div>

                        <div class="card-wrap">
                            <div class="card-header">
                                <h4>Pending Review</h4>
                            </div>
                            <div class="card-body">
                                0
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-lg-3 col-md-6 col-sm-6 col-12">
                    <div class="card card-statistic-1">
                        <div class="card-icon bg-success">
                            <i class="fas fa-money-bill"></i></div>
                        <div class="card-wrap">
                            <div class="card-header">
                                <h4>Total Sales</h4>
                            </div>
                            <div class="card-body">
                                3
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-lg-3 col-md-6 col-sm-6 col-12">
                    <div class="card card-statistic-1">
                        <div class="card-icon bg-danger">
                            <i class="fas fa-money-bill-wave"></i></div>
                        <div class="card-wrap">
                            <div class="card-header">
                                <h4>Total Sales</h4>
                            </div>
                            <div class="card-body">
                                $91.30
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <section class="card">
                <div class="card-body">
                    <form method="get" class="mb-0">
                        <input type="hidden" name="type" value="">
                        <div class="row">
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="input-label">Search</label>
                                    <input name="title" type="text" class="form-control" value="">
                                </div>
                            </div>

                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="input-label">Start Date</label>
                                    <div class="input-group">
                                        <input type="date" id="from" class="text-center form-control" name="from" value="" placeholder="Start Date">
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="input-label">End Date</label>
                                    <div class="input-group">
                                        <input type="date" id="to" class="text-center form-control" name="to" value="" placeholder="End Date">
                                    </div>
                                </div>
                            </div>


                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="input-label">Filters</label>
                                    <select name="sort" data-plugin-selecttwo="" class="form-control populate">
                                        <option value="">Filter Type</option>
                                        <option value="has_discount">Discounted Courses</option>
                                        <option value="sales_asc">Sales - Ascending</option>
                                        <option value="sales_desc">Sales - Descending</option>
                                        <option value="price_asc">Price - Ascending</option>
                                        <option value="price_desc">Price - Descending</option>
                                        <option value="income_asc">Income - Ascending</option>
                                        <option value="income_desc">Income - Descending</option>
                                        <option value="created_at_asc">Created Date - Ascending</option>
                                        <option value="created_at_desc">Created Date - Descending</option>
                                        <option value="updated_at_asc">Updated Date - Ascending</option>
                                        <option value="updated_at_desc">Updated Date - Descending</option>
                                    </select>
                                </div>
                            </div>


                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="input-label">Instructor</label>
                                    <select name="teacher_ids[]" multiple="" data-search-option="just_teacher_role" class="form-control search-user-select2 select2-hidden-accessible" data-placeholder="Search Instructors..." data-select2-id="select2-data-1-rvvx" tabindex="-1" aria-hidden="true">

                                    </select><span class="select2 select2-container select2-container--default" dir="ltr" data-select2-id="select2-data-2-4x37" style="width: 203.333px;"><span class="selection"><span class="select2-selection select2-selection--multiple" role="combobox" aria-haspopup="true" aria-expanded="false" tabindex="-1" aria-disabled="false"><ul class="select2-selection__rendered" id="select2-teacher_ids-0z-container"></ul><span class="select2-search select2-search--inline"><input class="select2-search__field" type="search" tabindex="0" autocorrect="off" autocapitalize="none" spellcheck="false" role="searchbox" aria-autocomplete="list" autocomplete="off" aria-describedby="select2-teacher_ids-0z-container" placeholder="Search Instructors..." style="width: 100%;"></span></span></span><span class="dropdown-wrapper" aria-hidden="true"></span></span>
                                </div>
                            </div>


                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="input-label">Category</label>
                                    <select name="category_id" data-plugin-selecttwo="" class="form-control populate">
                                        <option value="">All Categories</option>

                                        <option value="520">Design</option>
                                        <optgroup label="Academics">
                                            <option value="601">Math</option>
                                            <option value="602">Science</option>
                                            <option value="603">Language</option>
                                        </optgroup>
                                        <option value="523">Health &amp; Fitness</option>
                                        <optgroup label="Lifestyle">
                                            <option value="604">Lifestyle</option>
                                            <option value="605">Beauty &amp; Makeup</option>
                                        </optgroup>
                                        <option value="525">Marketing</option>
                                        <optgroup label="Business">
                                            <option value="609">Management</option>
                                            <option value="610">Communications</option>
                                            <option value="611">Business Strategy</option>
                                        </optgroup>
                                        <optgroup label="Development">
                                            <option value="606">Web Development</option>
                                            <option value="607">Mobile Development</option>
                                            <option value="608">Game Development</option>
                                        </optgroup>
                                    </select>
                                </div>
                            </div>


                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="input-label">Status</label>
                                    <select name="status" data-plugin-selecttwo="" class="form-control populate">
                                        <option value="">All Statuses</option>
                                        <option value="pending">Pending Review</option>
                                        <option value="active">Published</option>
                                        <option value="inactive">Rejected</option>
                                        <option value="is_draft">Draft</option>
                                    </select>
                                </div>
                            </div>


                            <div class="col-md-3">
                                <div class="form-group mt-1">
                                    <label class="input-label mb-4"> </label>
                                    <input type="submit" class="text-center btn btn-primary w-100" value="Show Results">
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </section>

            <div class="row">
                <div class="col-12 col-md-12">
                    <div class="card">
                        <div class="card-header">
                            <div class="text-right">
                                <a href="/admin/bundles/excel?" class="btn btn-primary">Export Excel</a>
                            </div>
                        </div>

                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-striped font-14 ">
                                    <tbody><tr>
                                        <th>ID</th>
                                        <th class="text-left">Title</th>
                                        <th class="text-left">Instructor</th>
                                        <th>Price</th>
                                        <th>Sales</th>
                                        <th>Income</th>
                                        <th>Courses Count</th>
                                        <th>Created Date</th>
                                        <th>Updated Date</th>
                                        <th>Status</th>
                                        <th width="120">Actions</th>
                                    </tr>

                                    <tr class="text-center">
                                        <td>3</td>
                                        <td width="18%" class="text-left">
                                            <a class="text-primary mt-0 mb-1 font-weight-bold" href="https://lms.rocket-soft.org/bundles/Solar-Energy-Design-Course-From-Zero-To-Hero">Solar Energy Design Course From Zero To Hero</a>
                                            <div class="text-small">Science</div>
                                        </td>

                                        <td class="text-left">Kate Williams</td>

                                        <td>
                                                                                                    <span class="mt-0 mb-1">
                                                        $25
                                                    </span>

                                        </td>
                                        <td>
                                                <span class="text-primary mt-0 mb-1 font-weight-bold">
                                                    1
                                                </span>
                                        </td>

                                        <td>$27.50</td>

                                        <td class="font-12">
                                            2
                                        </td>

                                        <td class="font-12">2022 Jun 25 | 02:45</td>

                                        <td class="font-12">2022 Jun 25 | 02:47</td>

                                        <td>
                                            <div class="text-success font-600-bold">Published</div>
                                        </td>
                                        <td width="150">
                                            <div class="btn-group dropdown table-actions">
                                                <button type="button" class="btn-transparent dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                    <i class="fa fa-ellipsis-v"></i>
                                                </button>
                                                <div class="dropdown-menu text-left webinars-lists-dropdown">
                                                    <a href="/admin/bundles/3/sendNotification" target="_blank" class="d-flex align-items-center text-dark text-decoration-none btn-transparent btn-sm text-primary mt-1 ">
                                                        <i class="fa fa-bell"></i>
                                                        <span class="ml-2">Send notification</span>
                                                    </a>

                                                    <a href="/admin/bundles/3/students" target="_blank" class="d-flex align-items-center text-dark text-decoration-none btn-transparent btn-sm text-primary mt-1 " title="Students">
                                                        <i class="fa fa-users"></i>
                                                        <span class="ml-2">Students</span>
                                                    </a>

                                                    <a href="/admin/supports/create?user_id=929" target="_blank" class="d-flex align-items-center text-dark text-decoration-none btn-transparent btn-sm text-primary mt-1" title="Send a message to the instructor">
                                                        <i class="fa fa-comment"></i>
                                                        <span class="ml-2">Send Message</span>
                                                    </a>

                                                    <a href="/admin/bundles/3/edit" target="_blank" class="d-flex align-items-center text-dark text-decoration-none btn-transparent btn-sm text-primary mt-1 " title="Edit">
                                                        <i class="fa fa-edit"></i>
                                                        <span class="ml-2">Edit</span>
                                                    </a>

                                                    <button class="btn-transparent text-primary d-flex align-items-center text-dark text-decoration-none btn-transparent btn-sm mt-1 trigger--fire-modal-1" data-confirm="Are you sure? | Do you want to continue?" data-confirm-href="/admin/bundles/3/delete" data-confirm-text-yes="Yes" data-confirm-text-cancel="Cancel">
                                                        <i class="fa fa-times"></i><span class="ml-2">Delete</span>
                                                    </button>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                    <tr class="text-center">
                                        <td>2</td>
                                        <td width="18%" class="text-left">
                                            <a class="text-primary mt-0 mb-1 font-weight-bold" href="https://lms.rocket-soft.org/bundles/A-Z-Web-Programming">A-Z Web Programming</a>
                                            <div class="text-small">Web Development</div>
                                        </td>

                                        <td class="text-left">Linda Anderson</td>

                                        <td>
                                                                                                    <span class="mt-0 mb-1">
                                                        $8
                                                    </span>

                                        </td>
                                        <td>
                                                <span class="text-primary mt-0 mb-1 font-weight-bold">
                                                    1
                                                </span>
                                        </td>

                                        <td>$8.80</td>

                                        <td class="font-12">
                                            2
                                        </td>

                                        <td class="font-12">2022 Jun 25 | 02:32</td>

                                        <td class="font-12">2022 Jun 25 | 02:35</td>

                                        <td>
                                            <div class="text-success font-600-bold">Published</div>
                                        </td>
                                        <td width="150">
                                            <div class="btn-group dropdown table-actions">
                                                <button type="button" class="btn-transparent dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                    <i class="fa fa-ellipsis-v"></i>
                                                </button>
                                                <div class="dropdown-menu text-left webinars-lists-dropdown">
                                                    <a href="/admin/bundles/2/sendNotification" target="_blank" class="d-flex align-items-center text-dark text-decoration-none btn-transparent btn-sm text-primary mt-1 ">
                                                        <i class="fa fa-bell"></i>
                                                        <span class="ml-2">Send notification</span>
                                                    </a>

                                                    <a href="/admin/bundles/2/students" target="_blank" class="d-flex align-items-center text-dark text-decoration-none btn-transparent btn-sm text-primary mt-1 " title="Students">
                                                        <i class="fa fa-users"></i>
                                                        <span class="ml-2">Students</span>
                                                    </a>

                                                    <a href="/admin/supports/create?user_id=934" target="_blank" class="d-flex align-items-center text-dark text-decoration-none btn-transparent btn-sm text-primary mt-1" title="Send a message to the instructor">
                                                        <i class="fa fa-comment"></i>
                                                        <span class="ml-2">Send Message</span>
                                                    </a>

                                                    <a href="/admin/bundles/2/edit" target="_blank" class="d-flex align-items-center text-dark text-decoration-none btn-transparent btn-sm text-primary mt-1 " title="Edit">
                                                        <i class="fa fa-edit"></i>
                                                        <span class="ml-2">Edit</span>
                                                    </a>

                                                    <button class="btn-transparent text-primary d-flex align-items-center text-dark text-decoration-none btn-transparent btn-sm mt-1 trigger--fire-modal-2" data-confirm="Are you sure? | Do you want to continue?" data-confirm-href="/admin/bundles/2/delete" data-confirm-text-yes="Yes" data-confirm-text-cancel="Cancel">
                                                        <i class="fa fa-times"></i><span class="ml-2">Delete</span>
                                                    </button>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                    <tr class="text-center">
                                        <td>1</td>
                                        <td width="18%" class="text-left">
                                            <a class="text-primary mt-0 mb-1 font-weight-bold" href="https://lms.rocket-soft.org/bundles/Microsoft-Office-Beginner-to-Expert-Bundle">Microsoft Office Beginner to Expert Bundle</a>
                                            <div class="text-small">Management</div>
                                        </td>

                                        <td class="text-left">Robert Ransdell</td>

                                        <td>
                                                                                                    <span class="mt-0 mb-1">
                                                        $50
                                                    </span>

                                        </td>
                                        <td>
                                                <span class="text-primary mt-0 mb-1 font-weight-bold">
                                                    1
                                                </span>
                                        </td>

                                        <td>$55</td>

                                        <td class="font-12">
                                            4
                                        </td>

                                        <td class="font-12">2022 Jun 24 | 10:54</td>

                                        <td class="font-12">2022 Jun 28 | 02:56</td>

                                        <td>
                                            <div class="text-success font-600-bold">Published</div>
                                        </td>
                                        <td width="150">
                                            <div class="btn-group dropdown table-actions">
                                                <button type="button" class="btn-transparent dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                    <i class="fa fa-ellipsis-v"></i>
                                                </button>
                                                <div class="dropdown-menu text-left webinars-lists-dropdown">
                                                    <a href="/admin/bundles/1/sendNotification" target="_blank" class="d-flex align-items-center text-dark text-decoration-none btn-transparent btn-sm text-primary mt-1 ">
                                                        <i class="fa fa-bell"></i>
                                                        <span class="ml-2">Send notification</span>
                                                    </a>

                                                    <a href="/admin/bundles/1/students" target="_blank" class="d-flex align-items-center text-dark text-decoration-none btn-transparent btn-sm text-primary mt-1 " title="Students">
                                                        <i class="fa fa-users"></i>
                                                        <span class="ml-2">Students</span>
                                                    </a>

                                                    <a href="/admin/supports/create?user_id=1015" target="_blank" class="d-flex align-items-center text-dark text-decoration-none btn-transparent btn-sm text-primary mt-1" title="Send a message to the instructor">
                                                        <i class="fa fa-comment"></i>
                                                        <span class="ml-2">Send Message</span>
                                                    </a>

                                                    <a href="/admin/bundles/1/edit" target="_blank" class="d-flex align-items-center text-dark text-decoration-none btn-transparent btn-sm text-primary mt-1 " title="Edit">
                                                        <i class="fa fa-edit"></i>
                                                        <span class="ml-2">Edit</span>
                                                    </a>

                                                    <button class="btn-transparent text-primary d-flex align-items-center text-dark text-decoration-none btn-transparent btn-sm mt-1 trigger--fire-modal-3" data-confirm="Are you sure? | Do you want to continue?" data-confirm-href="/admin/bundles/1/delete" data-confirm-text-yes="Yes" data-confirm-text-cancel="Cancel">
                                                        <i class="fa fa-times"></i><span class="ml-2">Delete</span>
                                                    </button>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                    </tbody></table>
                            </div>
                        </div>

                        <div class="card-footer text-center">

                        </div>

                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection

@push('scripts_bottom')

@endpush
