<section class="card">
    <div class="card-body">
        <form method="post" action="/admin" class="mb-0">
            @csrf

            <div class="row">


                <div class="col-md-4">
                    <div class="form-group">
                        <label class="input-label">Start Date </label>
                        <div class="input-group">
                            <input type="date" id="from" class="text-center form-control" name="from" value="  " placeholder="Start Date" required>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label class="input-label">End Date </label>
                        <div class="input-group">
                            <input type="date" id="to" class="text-center form-control" name="to" value=" " placeholder="End Date" required>
                        </div>
                    </div>
                </div>


                <div class="col-md-4">
                    <div class="form-group mt-1">
                        <label class="input-label mb-4"> </label>
                        <input type="submit" class="text-center btn btn-primary w-100" value="Show Results">
                    </div>
                </div>
            </div>
        </form>
    </div>
</section>
@if($from)
<p class="text-danger">Search Date {{$from}} to {{$to}} </p>
@endif


<section class="section">


    <div class="row">

        <div class="col-lg-3 col-md-6 col-sm-6 col-12">
            <a href="{{ getAdminPanelUrl() }}/instructors" class="card card-statistic-1">
                <div class="card-icon bg-primary">
                    <i class="fas fa-user"></i>
                </div>
                <div class="card-wrap">
                    <div class="card-header">
                        <h4>{{trans('admin/main.total_instructors')}}</h4>
                    </div>
                    <div class="card-body">
                        {{ $instructorCount }}
                    </div>
                </div>
            </a>
        </div>

        <div class="col-lg-3 col-md-6 col-sm-6 col-12">
            <a href="{{ getAdminPanelUrl() }}/students" class="card card-statistic-1">
                <div class="card-icon bg-primary">
                    <i class="fas fa-user"></i>
                </div>
                <div class="card-wrap">
                    <div class="card-header">
                        <h4>{{trans('admin/main.total_students')}}</h4>
                    </div>
                    <div class="card-body">
                        {{ $studentCount }}
                    </div>
                </div>
            </a>
        </div>
        <div class="col-lg-3 col-md-6 col-sm-6 col-12">
            <a href="{{ getAdminPanelUrl() }}/webinars" class="card card-statistic-1">
                <div class="card-icon bg-primary">
                    <i class="fas fa-file-video"></i>
                </div>
                <div class="card-wrap">
                    <div class="card-header">
                        <h4>{{trans('admin/main.courses')}}</h4>
                    </div>
                    <div class="card-body">
                        {{ $courseCount }}
                    </div>
                </div>
            </a>
        </div>
        <div class="col-lg-3 col-md-6 col-sm-6 col-12">
            <a href="{{ getAdminPanelUrl() }}/webinars" class="card card-statistic-1">
                <div class="card-icon bg-primary">
                    <i class="fas fa-file-video"></i>
                </div>
                <div class="card-wrap">
                    <div class="card-header">
                        <h4>{{trans('Live Courses')}}</h4>
                    </div>
                    <div class="card-body">
                        {{ $liveCount }}
                    </div>
                </div>
            </a>
        </div>
        <div class="col-lg-3 col-md-6 col-sm-6 col-12">
            <a href="{{ getAdminPanelUrl() }}/webinars" class="card card-statistic-1">
                <div class="card-icon bg-primary">
                    <i class="fas fa-file-video"></i>
                </div>
                <div class="card-wrap">
                    <div class="card-header">
                        <h4>{{trans('Video Courses')}}</h4>
                    </div>
                    <div class="card-body">
                        {{ $videoCount }}
                    </div>
                </div>
            </a>
        </div>
        <div class="col-lg-3 col-md-6 col-sm-6 col-12">
            <a href="{{ getAdminPanelUrl() }}/quizzes" class="card card-statistic-1">
                <div class="card-icon bg-primary">
                    <i class="fas fa-file-alt"></i>
                </div>
                <div class="card-wrap">
                    <div class="card-header">
                        <h4>{{trans('admin/main.total_quizzes')}}</h4>
                    </div>
                    <div class="card-body">
                        {{ $quizCount }}
                    </div>
                </div>
            </a>
        </div>
        <div class="col-lg-3 col-md-6 col-sm-6 col-12">
            <a href="{{ getAdminPanelUrl() }}/blog" class="card card-statistic-1">
                <div class="card-icon bg-primary">
                    <i class="fas fa-file-alt"></i>
                </div>
                <div class="card-wrap">
                    <div class="card-header">
                        <h4>{{trans('Blogs')}}</h4>
                    </div>
                    <div class="card-body">
                        {{ $blogCount }}
                    </div>
                </div>
            </a>
        </div>
        <div class="col-lg-3 col-md-6 col-sm-6 col-12">
            <a href="{{ getAdminPanelUrl() }}/forums" class="card card-statistic-1">
                <div class="card-icon bg-primary">
                    <i class="fas fa-file-alt"></i>
                </div>
                <div class="card-wrap">
                    <div class="card-header">
                        <h4>{{trans('Forum Topic')}}</h4>
                    </div>
                    <div class="card-body">
                        {{ $forumCount }}
                    </div>
                </div>
            </a>
        </div>
    </div>


    <div class="row">

        <div class="col-lg-4 col-md-12 col-12 col-sm-12">
            <div class="card">
                <div class="card-header">
                    <h4>{{trans('admin/main.user_type_statistics')}}</h4>
                </div>
                <div class="card-body">
                    <canvas id="userTypeStatisticsChart" height="490"></canvas>
                </div>
            </div>
        </div>
        <div class="col-lg-4 col-md-12 col-12 col-sm-12">
            <div class="card">
                <div class="card-header">
                    <h4>{{trans('admin/main.user_statistics')}}</h4>
                </div>
                <div class="card-body">
                    <canvas id="userStatusStatisticsChart" height="490"></canvas>
                </div>
            </div>
        </div>
        <div class="col-lg-4 col-md-12 col-12 col-sm-12">
            <div class="card">
                <div class="card-header">
                    <h4>{{trans('admin/main.classes_statistics')}}</h4>
                </div>
                <div class="card-body">
                    <canvas id="classesStatisticsChart" height="490"></canvas>
                </div>
            </div>
        </div>
    </div>



    <div class="row">
            <div class="col-lg-12 col-md-12 col-12 col-sm-12">
                <div class="card">
                    <div class="card-header">
                        <h4>{{trans('admin/main.new_registration_statistics')}}</h4>
                        <div class="card-header-action">
                            <div class="btn-group">
                                {{--<a href="#" class="btn">Views
                                </a>--}}
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-12">
                                <div class="position-relative">
                                    <canvas id="usersStatisticsChart"></canvas>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    <div class="row">
        <div class="col-lg-12 col-md-12 col-12 col-sm-12">
            <div class="card">
                <div class="card-header">
                    <h4>{{trans('admin/main.new_registration_statistics')}}</h4>
                    <div class="card-header-action">
                        <div class="btn-group">
                            {{--<a href="#" class="btn">Views
                            </a>--}}
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-12">
                            <div class="position-relative">
                                <canvas id="myChart" style="width:100%;"></canvas>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>

    <div class="row">
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h4>{{trans('admin/main.top_classes')}}</h4>
                    <div class="card-header-action">
                        <a href="{{ getAdminPanelUrl() }}/webinars?type=course&sort=sales_desc"
                           class="btn btn-primary">{{trans('admin/main.view_more')}}<i class="fas fa-chevron-right"></i></a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive text-center">
                        <table class="table table-striped font-14">

                            <tr>
                                <th>#</th>
                                <th class="text-left">{{trans('admin/main.name')}}</th>
                                <th>{{trans('admin/main.enrolled')}}</th>

                            </tr>

                            @foreach($getTopSellingClasses as $getTopSellingClass)
                                <tr>
                                    <td>{{ $getTopSellingClass->id }}</td>
                                    <td>
                                        <a href="{{ $getTopSellingClass->getUrl() }}" target="_blank"
                                           class="media-body text-left">
                                            <div>{{ $getTopSellingClass->title }}</div>
                                            <div
                                                class="text-primary text-small font-600-bold">{{ trans('webinars.'.$getTopSellingClass->type) }}</div>
                                        </a>
                                    </td>
                                    <td>{{ $getTopSellingClass->sales_count }}</td>

                                </tr>
                            @endforeach
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h4>{{trans('admin/main.top_instructors')}}</h4>
                    <div class="card-header-action">
                        <a href="{{ getAdminPanelUrl() }}/instructors?sort=sales_classes_desc"
                           class="btn btn-sm btn-primary">{{trans('admin/main.view_more')}}<i
                                class="fas fa-chevron-right"></i></a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive text-center">
                        <table class="table table-striped font-14">
                            <tr>
                                <th>{{trans('admin/main.id')}}</th>
                                <th class="text-left">{{trans('admin/main.name')}}</th>
                                <th>{{trans('admin/main.classes_durations')}}</th>
                                <th>{{trans('admin/main.enrolled')}}</th>


                            </tr>

                            @foreach($getTopSellingTeachers as $getTopSellingTeacher)
                                <tr>
                                    <td>{{ $getTopSellingTeacher->id }}</td>
                                    <td class="text-left">{{ $getTopSellingTeacher->full_name }}</td>
                                    <td>{{ convertMinutesToHourAndMinute($getTopSellingTeacher->classes_durations) }}
                                        Hours
                                    </td>
                                    <td>{{ $getTopSellingTeacher->sales_count }}</td>

                                </tr>
                            @endforeach
                        </table>
                    </div>
                </div>
            </div>
        </div>

    </div>
    <div class="row">

        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h4>{{trans('admin/main.most_active_students')}}</h4>
                    <div class="card-header-action">
                        <a href="{{ getAdminPanelUrl() }}/students?sort=register_desc"
                           class="btn btn-sm btn-primary">{{trans('admin/main.view_more')}}<i
                                class="fas fa-chevron-right"></i></a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive text-center">
                        <table class="table table-striped font-14">
                            <tr>
                                <th>#</th>
                                <th class="text-left">{{trans('admin/main.name')}}</th>
                                <th>{{trans('admin/main.enrolled_classes')}}</th>

                            </tr>
                            @foreach($getMostActiveStudents as $getMostActiveStudent)
                                <tr>
                                    <td>{{ $getMostActiveStudent->id }}</td>
                                    <td class="text-left">{{ $getMostActiveStudent->full_name }}</td>
                                    <td>{{ $getMostActiveStudent->purchased_classes }}</td>

                                </tr>
                            @endforeach
                        </table>
                    </div>
                </div>
            </div>
        </div>

    </div>




</section>
