@php
    $socials = getSocials();
    if (!empty($socials) and count($socials)) {
        $socials = collect($socials)->sortBy('order')->toArray();
    }

    $footerColumns = getFooterColumns();
@endphp

<style>
    .shadow-effect {
        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        transition: box-shadow 0.3s ease-in-out;
    }

    .instructors-card-avatar img {
        max-width: 100%;
        height: auto;
    }
</style>

<section class="home-sections container">
    <div class="d-flex justify-content-between">
        <div>
            <h2 class="section-title">Our Supported Partners</h2>
            <p class="section-hint"># Empowering Collaborative &amp; Excellence</p>
        </div>
    </div>
    {{--<div class="owl-carousel customers-testimonials instructors-swiper-container owl-loaded owl-drag">
        <div class="owl-stage-outer">
            <div class="owl-stage" style="transition: all 0.45s ease 0s; width: 4163px; transform: translate3d(-1526px, 0px, 0px);">
                <div class="owl-item cloned" style="width: 277.5px;">
                    <div class="item">
                        <div class="shadow-effect">
                            <div class="instructors-card d-flex flex-column align-items-center justify-content-center">
                                <div class="instructors-card-avatar d-flex flex-column align-items-center justify-content-center">
                                    <img src="/store/partners/Flag_of_South_Sudan.png" alt="Kate Williams" class=" img-cover">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="owl-item cloned" style="width: 277.5px;">
                    <div class="item">
                        <div class="shadow-effect">
                            <div class="instructors-card d-flex flex-column align-items-center justify-content-center">
                                <div class="instructors-card-avatar d-flex flex-column align-items-center justify-content-center">
                                    <img src="/store/partners/Ministry-of-Trade.png" alt="Linda Anderson" class=" img-cover">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="owl-item cloned" style="width: 277.5px;">
                    <div class="item">
                        <div class="shadow-effect">
                            <div class="instructors-card d-flex flex-column align-items-center justify-content-center">
                                <div class="instructors-card-avatar d-flex flex-column align-items-center justify-content-center">
                                    <img src="/store/partners/dutch.png" alt="Robert Ransdell" class=" img-cover">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="owl-item cloned" style="width: 277.5px;">
                    <div class="item">
                        <div class="shadow-effect">
                            <div class="instructors-card d-flex flex-column align-items-center justify-content-center">
                                <div class="instructors-card-avatar d-flex flex-column align-items-center justify-content-center">
                                    <img src="/store/partners/EIF.png" alt="Ricardo dave" class=" img-cover">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="owl-item" style="width: 277.5px;">
                    <div class="item">
                        <div class="shadow-effect">
                            <div class="instructors-card d-flex flex-column align-items-center justify-content-center">
                                <div class="instructors-card-avatar d-flex flex-column align-items-center justify-content-center">
                                    <img src="/store/partners/afdb.png" alt="James Kong" class=" img-cover">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="owl-item" style="width: 277.5px;">
                    <div class="item">
                        <div class="shadow-effect">
                            <div class="instructors-card d-flex flex-column align-items-center justify-content-center">
                                <div class="instructors-card-avatar d-flex flex-column align-items-center justify-content-center">
                                    <img src="/store/partners/UNDP-Logo-Blue-Large-Transparent-1.png" alt="Jessica Wray" class=" img-cover">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="owl-nav disabled"><button type="button" role="presentation" class="owl-prev"><span aria-label="Previous">‹</span></button><button type="button" role="presentation" class="owl-next"><span aria-label="Next"></span></button></div>
    </div>
--}}

    <!-- Add more items as needed -->

    <div class="row">
        <div class="col-6 col-md-2">
            <div class="shadow-effect">
                <div class="instructors-card d-flex flex-column align-items-center justify-content-center">
                    <div class="instructors-card-avatar d-flex flex-column align-items-center justify-content-center">
                        <img src="/store/partners/Flag_of_South_Sudan.png" alt="Flag of South Sudan" class="mx-auto d-block">
                    </div>
                </div>
            </div>
        </div>

        <div class="col-6 col-md-2">
            <div class="shadow-effect">
                <div class="instructors-card d-flex flex-column align-items-center justify-content-center">
                    <div class="instructors-card-avatar d-flex flex-column align-items-center justify-content-center">
                        <img src="/store/partners/Ministry-of-Trade.png" alt="Ministry of Trade" class="mx-auto d-block">
                    </div>
                </div>
            </div>
        </div>

        <div class="col-6 col-md-2">
            <div class="shadow-effect">
                <div class="instructors-card d-flex flex-column align-items-center justify-content-center">
                    <div class="instructors-card-avatar d-flex flex-column align-items-center justify-content-center">
                        <img src="/store/partners/dutch.png" alt="Dutch" class="mx-auto d-block">
                    </div>
                </div>
            </div>
        </div>

        <div class="col-6 col-md-2">
            <div class="shadow-effect">
                <div class="instructors-card d-flex flex-column align-items-center justify-content-center">
                    <div class="instructors-card-avatar d-flex flex-column align-items-center justify-content-center">
                        <img src="/store/partners/EIF.png" alt="EIF" class="mx-auto d-block">
                    </div>
                </div>
            </div>
        </div>

        <div class="col-6 col-md-2">
            <div class="shadow-effect">
                <div class="instructors-card d-flex flex-column align-items-center justify-content-center">
                    <div class="instructors-card-avatar d-flex flex-column align-items-center justify-content-center">
                        <img src="/store/partners/afdb.png" alt="AfDB" class="mx-auto d-block">
                    </div>
                </div>
            </div>
        </div>

        <div class="col-6 col-md-2">
            <div class="shadow-effect">
                <div class="instructors-card d-flex flex-column align-items-center justify-content-center">
                    <div class="instructors-card-avatar d-flex flex-column align-items-center justify-content-center">
                        <img src="/store/partners/UNDP-Logo-Blue-Large-Transparent-1.png" alt="UNDP Logo" class="mx-auto d-block">
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<footer class="footer bg-secondary position-relative user-select-none" id="footer">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class=" footer-subscribe d-block d-md-flex align-items-center justify-content-between">
                    <div class="flex-grow-1">
                        <strong>{{ trans('footer.join_us_today') }}</strong>
                        <span class="d-block mt-5 text-white">{{ trans('footer.subscribe_content') }}</span>
                    </div>
                    <div class="subscribe-input bg-white p-10 flex-grow-1 mt-30 mt-md-0">
                        <form action="/newsletters" method="post">
                            {{ csrf_field() }}

                            <div class="form-group d-flex align-items-center m-0">
                                <div class="w-100">
                                    <input type="text" name="newsletter_email"
                                           class="form-control border-0 @error('newsletter_email') is-invalid @enderror"
                                           placeholder="{{ trans('footer.enter_email_here') }}"/>
                                    @error('newsletter_email')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                                <button type="submit"
                                        class="btn btn-orange rounded-pill">{{ trans('footer.join') }}</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @php
        $columns = ['first_column','second_column','third_column','forth_column'];
    @endphp

    <div class="container">
        <div class="row">
            @foreach($columns as $column)
                <div class="col-6 col-md-3">
                    @if(!empty($footerColumns[$column]))
                        @if(!empty($footerColumns[$column]['title']))
                            <span class="header d-block font-weight-bold text-white">{{ $footerColumns[$column]['title'] }}</span>
                        @endif

                        @if(!empty($footerColumns[$column]['value']))
                            <div class="">
                                {!! $footerColumns[$column]['value'] !!}
                            </div>
                        @endif
                    @endif
                </div>
            @endforeach

        </div>

        {{--<div class="mt-40 border-blue py-5 d-flex align-items-center justify-content-between">
            --}}{{-- <div class="footer-logo">
                 <a href="/">
                     @if(!empty($generalSettings['footer_logo']))
                         <img src="{{ $generalSettings['footer_logo'] }}" class="img-cover" alt="footer logo">
                     @endif
                 </a>
             </div>--}}{{--
            <div class="footer-logo ">Technical Partner:&nbsp;&nbsp;
                <a href="/">
                    <img src="/store/1/a2i-Logo-set-1024x136.png" class="footer-img-cover" alt="footer logo">
                </a>
            </div>
            <div class="footer-social">
                @if(!empty($socials) and count($socials))
                    @foreach($socials as $social)
                        <a href="{{ $social['link'] }}">
                            <img src="{{ $social['image'] }}" alt="{{ $social['title'] }}" class="mr-15">
                        </a>
                    @endforeach
                @endif
            </div>
        </div>--}}
    </div>

    @if(getOthersPersonalizationSettings('platform_phone_and_email_position') == 'footer')
        <div class="footer-copyright-card">
            <div class="container d-flex align-items-center justify-content-center py-15">
                <div class="font-14 text-white">{{ trans('update.platform_copyright_hint') }} <a href="/">
                        <img src="/store/1/bizex-logo.png" height="25px" class="thumbnail" alt="footer logo">
                    </a>
                </div>

                {{--<div class="d-flex align-items-center justify-content-center">
                    @if(!empty($generalSettings['site_phone']))
                        <div class="d-flex align-items-center font-14">
                            <i data-feather="phone" width="20" height="20" class="mr-10"></i>
                            {{ $generalSettings['site_phone'] }}
                        </div>
                    @endif

                    @if(!empty($generalSettings['site_email']))
                        <div class="border-left mx-5 mx-lg-15 h-100"></div>

                        <div class="d-flex align-items-center font-14">
                            <i data-feather="mail" width="20" height="20" class="mr-10"></i>
                            {{ $generalSettings['site_email'] }}
                        </div>
                    @endif
                </div>--}}
            </div>
        </div>
    @endif

</footer>
@push('script')
    {{--<script>
        $(document).ready(function () {
            $('.owl-carousel').owlCarousel({
                loop: true,
                margin: 10,
                autoplay: true,
                autoplayTimeout: 3000,
                responsive: {
                    0: {
                        items: 2
                    },
                    600: {
                        items: 4
                    },
                    1000: {
                        items: 6
                    }
                }
            });
        });
    </script>--}}
@endpush
