@php
    if (empty($authUser) and auth()->check()) {
        $authUser = auth()->user();
    }

    $navBtnUrl = null;
    $navBtnText = null;

    if(request()->is('forums*')) {
        $navBtnUrl = '/forums/create-topic';
        $navBtnText = trans('update.create_new_topic');
    } else {
        $navbarButton = getNavbarButton(!empty($authUser) ? $authUser->role_id : null, empty($authUser));

        if (!empty($navbarButton)) {
            $navBtnUrl = $navbarButton->url;
            $navBtnText = $navbarButton->title;
        }
    }
@endphp
@php
    $userLanguages = !empty($generalSettings['site_language']) ? [$generalSettings['site_language'] => getLanguages($generalSettings['site_language'])] : [];

    if (!empty($generalSettings['user_languages']) and is_array($generalSettings['user_languages'])) {
        $userLanguages = getLanguages($generalSettings['user_languages']);
    }

    $localLanguage = [];

    foreach($userLanguages as $key => $userLanguage) {
        $localLanguage[localeToCountryCode($key)] = $userLanguage;
    }

@endphp

<div id="navbarVacuum"></div>
<nav id="navbar" class="navbar navbar-expand-lg navbar-light">
    <div class="{{ (!empty($isPanel) and $isPanel) ? 'container-fluid' : 'container'}}">
        <div class="d-flex align-items-center justify-content-between w-100">

            <a class="navbar-brand navbar-order d-flex align-items-center justify-content-center mr-0 {{ (empty($navBtnUrl) and empty($navBtnText)) ? 'ml-auto' : '' }}"
               href="/">
                @if(!empty($generalSettings['logo']))
                    <img src="{{ $generalSettings['logo'] }}" class="img-cover" alt="site logo">
                @endif
            </a>

            <button class="navbar-toggler navbar-order" type="button" id="navbarToggle">
                <span class="navbar-toggler-icon"></span>
            </button>

            <div class="mx-lg-30 d-none d-lg-flex flex-grow-1 navbar-toggle-content " style="background-color: #334FBA " id="navbarContent">
                <div class="navbar-toggle-header text-right d-lg-none">
                    <button class="btn-transparent" id="navbarClose">
                        <i data-feather="x" width="32" height="32"></i>
                    </button>
                </div>

                <ul class="navbar-nav mr-auto d-flex align-items-center">
                    @if(!empty($categories) and count($categories))
                        <li class="mr-lg-25">
                            <div class="menu-category">
                                <ul>
                                    <li class="cursor-pointer user-select-none d-flex xs-categories-toggle">
                                        <i data-feather="grid" width="20" height="20"
                                           class="{{--mr-10--}} d-none d-lg-block"></i>
                                        {{-- {{ trans('categories.categories') }}--}}

                                        <ul class="cat-dropdown-menu">
                                            @foreach($categories as $category)
                                                <li>
                                                    <a href="{{ $category->getUrl() }}"
                                                       class="{{ (!empty($category->subCategories) and count($category->subCategories)) ? 'js-has-subcategory' : '' }}">
                                                        <div class="d-flex align-items-center">
                                                            <img src="{{ $category->icon }}"
                                                                 class="cat-dropdown-menu-icon mr-10"
                                                                 alt="{{ $category->title }} icon">
                                                            {{ $category->title }}
                                                        </div>

                                                        @if(!empty($category->subCategories) and count($category->subCategories))
                                                            <i data-feather="chevron-right" width="20" height="20"
                                                               class="d-none d-lg-inline-block ml-10"></i>
                                                            <i data-feather="chevron-down" width="20" height="20"
                                                               class="d-inline-block d-lg-none"></i>
                                                        @endif
                                                    </a>

                                                    @if(!empty($category->subCategories) and count($category->subCategories))
                                                        <ul class="sub-menu" data-simplebar
                                                            @if((!empty($isRtl) and $isRtl)) data-simplebar-direction="rtl" @endif>
                                                            @foreach($category->subCategories as $subCategory)
                                                                <li>
                                                                    <a href="{{ $subCategory->getUrl() }}">
                                                                        @if(!empty($subCategory->icon))
                                                                            <img src="{{ $subCategory->icon }}"
                                                                                 class="cat-dropdown-menu-icon mr-10"
                                                                                 alt="{{ $subCategory->title }} icon">
                                                                        @endif

                                                                        {{ $subCategory->title }}
                                                                    </a>
                                                                </li>
                                                            @endforeach
                                                        </ul>
                                                    @endif
                                                </li>
                                            @endforeach
                                        </ul>
                                    </li>
                                </ul>
                            </div>
                        </li>
                    @endif

                    @if(!empty($navbarPages) and count($navbarPages))
                        @foreach($navbarPages as $navbarPage)
                            <li class="nav-item">
                                <a class="nav-link" href="{{ $navbarPage['link'] }}">{{ $navbarPage['title'] }}</a>
                            </li>
                        @endforeach
                    @endif

                    <li>
                        @if(!empty($authUser))

                            <div class="custom-dropdown navbar-auth-user-dropdown position-relative ml-50">
                                <div
                                    class="custom-dropdown-toggle d-flex align-items-center navbar-user cursor-pointer">
                                    <img src="{{ $authUser->getAvatar() }}" width="25px" class="rounded-circle"
                                         alt="{{ $authUser->full_name }}">
                                    <span class="font-16 user-name ml-10 text-dark-blue font-14">{{ $authUser->full_name }} </span>
                                    <img src="/assets/default/img/chevron-down.svg" width="15px" class="rounded-circle"
                                         alt="dropdown-icon">
                                </div>

                                <div class="custom-dropdown-body pb-10">

                                    <div
                                        class="dropdown-user-avatar d-flex align-items-center p-15 m-15 mb-10 rounded-sm border">
                                        <div class="size-40 rounded-circle position-relative">
                                            <img src="{{ $authUser->getAvatar() }}" width="25px"
                                                 class="img-cover rounded-circle" alt="{{ $authUser->full_name }}">


                                        </div>

                                        <div class="ml-5">
                                            <div
                                                class="font-14 font-weight-bold text-secondary">{{ $authUser->full_name }}</div>
                                            <span class="mt-5 text-gray font-12">{{ $authUser->role->caption }}</span>
                                        </div>
                                    </div>

                                    <ul class="my-8">
                                        @if($authUser->isAdmin())
                                            <li class="navbar-auth-user-dropdown-item">
                                                <a href="{{ getAdminPanelUrl() }}"
                                                   class="d-flex align-items-center w-100 px-15 py-10 text-gray font-14 bg-transparent">
                                                    <img src="/assets/default/img/icons/user_menu/dashboard.svg"
                                                         class="icons">
                                                    <span class="ml-5">{{ trans('panel.dashboard') }}</span>
                                                </a>
                                            </li>

                                            <li class="navbar-auth-user-dropdown-item">
                                                <a href="{{ getAdminPanelUrl("/settings") }}"
                                                   class="d-flex align-items-center w-100 px-15 py-10 text-gray font-14 bg-transparent">
                                                    <img src="/assets/default/img/icons/user_menu/settings.svg"
                                                         class="icons">
                                                    <span class="ml-5">{{ trans('panel.settings') }}</span>
                                                </a>
                                            </li>
                                        @else
                                            <li class="navbar-auth-user-dropdown-item">
                                                <a href="/panel"
                                                   class="d-flex align-items-center w-100 px-15 py-10 text-gray font-14 bg-transparent">
                                                    <img src="/assets/default/img/icons/user_menu/dashboard.svg"
                                                         class="icons">
                                                    <span class="ml-5">{{ trans('panel.dashboard') }}</span>
                                                </a>
                                            </li>


                                            <li class="navbar-auth-user-dropdown-item">
                                                <a href="{{ ($authUser->isUser()) ? '/panel/webinars/purchases' : '/panel/webinars' }}"
                                                   class="d-flex align-items-center w-100 px-15 py-10 text-gray font-14 bg-transparent">
                                                    <img src="/assets/default/img/icons/user_menu/my_courses.svg"
                                                         class="icons">
                                                    <span class="ml-5">{{ trans('update.my_courses') }}</span>
                                                </a>
                                            </li>

                                          {{--  @if(!$authUser->isUser())
                                                <li class="navbar-auth-user-dropdown-item">
                                                    <a href="/panel/financial/sales"
                                                       class="d-flex align-items-center w-100 px-15 py-10 text-gray font-14 bg-transparent">
                                                        <img src="/assets/default/img/icons/user_menu/sales_history.svg"
                                                             class="icons">
                                                        <span class="ml-5">{{ trans('financial.sales_history') }}</span>
                                                    </a>
                                                </li>
                                            @endif--}}

                                            <li class="navbar-auth-user-dropdown-item">
                                                <a href="/panel/support"
                                                   class="d-flex align-items-center w-100 px-15 py-10 text-gray font-14 bg-transparent">
                                                    <img src="/assets/default/img/icons/user_menu/support.svg"
                                                         class="icons">
                                                    <span class="ml-5">{{ trans('panel.support') }}</span>
                                                </a>
                                            </li>

                                            @if(!$authUser->isUser())
                                                <li class="navbar-auth-user-dropdown-item">
                                                    <a href="{{ $authUser->getProfileUrl() }}"
                                                       class="d-flex align-items-center w-100 px-15 py-10 text-gray font-14 bg-transparent">
                                                        <img src="/assets/default/img/icons/user_menu/profile.svg"
                                                             class="icons">
                                                        <span class="ml-5">{{ trans('public.profile') }}</span>
                                                    </a>
                                                </li>
                                            @endif

                                            <li class="navbar-auth-user-dropdown-item">
                                                <a href="/panel/setting"
                                                   class="d-flex align-items-center w-100 px-15 py-10 text-gray font-14 bg-transparent">
                                                    <img src="/assets/default/img/icons/user_menu/settings.svg"
                                                         class="icons">
                                                    <span class="ml-5">{{ trans('panel.settings') }}</span>
                                                </a>
                                            </li>
                                        @endif

                                        <li class="navbar-auth-user-dropdown-item">
                                            <a href="/logout"
                                               class="d-flex align-items-center w-100 px-15 py-10 text-danger font-14 bg-transparent">
                                                <img src="/assets/default/img/icons/user_menu/logout.svg" class="icons">
                                                <span class="ml-5">{{ trans('auth.logout') }}</span>
                                            </a>
                                        </li>

                                    </ul>

                                </div>
                            </div>
                        @else
                            <div class="d-flex align-items-center ml-md-50">
                                <a href="/login"
                                   class="py-5 px-10 mr-10 text-white-all font-14">{{ trans('auth.login') }}</a>
                                <a href="/register"
                                   class="py-5 px-10 text-white-all font-14">{{ trans('auth.register') }}</a>
                            </div>
                        @endif
                    </li>
                    <li>
                        @include(getTemplate().'.includes.shopping-cart-dropdwon')
                    </li>

                    <li>

                        <div class="custom-dropdown navbar-auth-user-dropdown position-relative ml-50">
                            <div class="custom-dropdown-toggle d-flex align-items-center navbar-user cursor-pointer">
                                <button
                                    class="btn-transparent d-flex align-items-center justify-content-center search-icon">
                                    <i id="search-icon" data-feather="search" width="20" height="20" class="mr-10" style="color: #FFFFFF;"></i>
                                </button>
                            </div>

                            <div class="custom-dropdown-body pb-10">

                                <form action="/search" method="get" style="margin-left: 40px; padding-top: 15px"
                                      class="form-inline my-2 my-lg-0  navbar-search position-relative"
                                      id="form-design">
                                    <input class="form-control mr-5 rounded" type="text" name="search"
                                           placeholder="{{ trans('navbar.search_anything') }}" aria-label="Search">

                                    <button type="submit"
                                            class="btn-transparent d-flex align-items-center justify-content-center search-icon">
                                        <i data-feather="search" width="20" height="20" class="mr-10"></i>
                                    </button>
                                </form>
                            </div>
                        </div>
                    </li>


                </ul>
            </div>


            <div class="nav-icons-or-start-live navbar-order d-flex align-items-center justify-content-end">
                @if(!empty($localLanguage) and count($localLanguage) > 1)
                    <form action="/locale" method="post" class="mr-15 mx-md-20">
                        {{ csrf_field() }}

                        <input type="hidden" name="locale">

                        @if(!empty($previousUrl))
                            <input type="hidden" name="previous_url" value="{{ $previousUrl }}">
                        @endif

                        <div class="language-select">
                            <div id="localItems"
                                 data-selected-country="{{ localeToCountryCode(mb_strtoupper(app()->getLocale())) }}"
                                 data-countries='{{ json_encode($localLanguage) }}'
                            ></div>
                        </div>
                    </form>
                @else
                    <div class="mr-15 mx-md-20"></div>
                @endif

                {{--   @if(!empty($navBtnUrl))
                       <a href="{{ $navBtnUrl }}" class="d-none d-lg-flex btn btn-sm btn-primary nav-start-a-live-btn">
                           {{ $navBtnText }}
                       </a>

                       <a href="{{ $navBtnUrl }}" class="d-flex d-lg-none text-primary nav-start-a-live-btn font-14">
                           {{ $navBtnText }}
                       </a>
                   @endif

                   @if(!empty($isPanel))
                       @if($authUser->checkAccessToAIContentFeature())
                           <div class="js-show-ai-content-drawer show-ai-content-drawer-btn d-flex-center mr-40">
                               <div class="d-flex-center size-32 rounded-circle bg-white">
                                   <img src="/assets/default/img/ai/ai-chip.svg" alt="ai" class="" width="16px"
                                        height="16px">
                               </div>
                               <span
                                   class="ml-5 font-weight-500 text-secondary font-14 d-none d-lg-block">{{ trans('update.ai_content') }}</span>
                           </div>
                       @endif
                   @endif

                   <div class="d-none nav-notify-cart-dropdown top-navbar">
                       @include('web.default.includes.shopping-cart-dropdwon')

                       <div class="border-left mx-15"></div>

                       @include('web.default.includes.notification-dropdown')
                   </div>--}}
            </div>
        </div>
    </div>
</nav>

@push('scripts_bottom')

    <script src="/assets/default/js/parts/navbar.min.js"></script>
    <link href="/assets/default/vendors/flagstrap/css/flags.css" rel="stylesheet">
    <script src="/assets/default/vendors/flagstrap/js/jquery.flagstrap.min.js"></script>
    <script src="/assets/default/js/parts/top_nav_flags.min.js"></script>
@endpush
