(function ($) {
  "use strict";

  $('body').on('click', '.add-meeting-url', function (e) {
    e.preventDefault();
    var item_id = $(this).attr('data-item-id');
    var meeting_password = $('.js-meeting-password-' + item_id).val();
    var meeting_link = $('.js-meeting-link-' + item_id).val();
    var $modalHtml = $('#liveMeetingLinkModal');
    Swal.fire({
      html: '<div id="meetingLinkModal">' + $modalHtml.html() + '</div>',
      showCancelButton: false,
      showConfirmButton: false,
      customClass: {
        content: 'p-0 text-left'
      },
      width: '48rem',
      onOpen: function onOpen() {
        var editModal = $('#meetingLinkModal');
        editModal.find('input[name="item_id"]').val(item_id);
        editModal.find('input[name="password"]').val(meeting_password);
        editModal.find('input[name="link"]').val(meeting_link);
      }
    });
  });
  $('body').on('click', '.js-save-meeting-link', function (e) {
    e.preventDefault();
    var $this = $(this);
    var $form = $this.closest('form');
    var action = $form.attr('action');
    var data = $form.serializeObject();
    $this.addClass('loadingbar primary').prop('disabled', true);
    $.post(action, data, function (result) {
      if (result && result.code === 200) {
        Swal.fire({
          icon: 'success',
          html: '<h3 class="font-20 text-center text-dark-blue">' + linkSuccessAdd + '</h3>',
          showConfirmButton: false
        });
        setTimeout(function () {
          window.location.reload();
        }, 2000);
      }
    }).fail(function (err) {
      $this.removeClass('loadingbar primary').prop('disabled', false);
      var errors = err.responseJSON;

      if (errors && errors.errors) {
        Object.keys(errors.errors).forEach(function (key) {
          var error = errors.errors[key];
          var element = $form.find('[name="' + key + '"]');
          element.addClass('is-invalid');
          element.parent().find('.invalid-feedback').text(error[0]);
        });
      }
    });
  });
  $('body').on('click', '.js-add-meeting-session', function (e) {
    e.preventDefault();
    var item_id = $(this).attr('data-item-id');
    var itemDate = $(this).attr('data-date');
    var $modalHtml = $('#meetingCreateSessionModal');
    Swal.fire({
      html: '<div id="meetingSessionModal">' + $modalHtml.html() + '</div>',
      showCancelButton: false,
      showConfirmButton: false,
      customClass: {
        content: 'p-0 text-left'
      },
      width: '42rem',
      onOpen: function onOpen() {
        var editModal = $('#meetingSessionModal');
        editModal.find('input[name="item_id"]').val(item_id);
        editModal.find('.js-meeting-date').text(itemDate);
        editModal.find('.js-create-meeting-session').removeClass('d-none');
        editModal.find('.js-create-meeting-session').attr('data-item-id', item_id);
        editModal.find('.js-join-to-session').addClass('d-none');
        editModal.find('.js-for-create-session-text').removeClass('d-none');
        editModal.find('.js-for-join-session-text').addClass('d-none');
      }
    });
  });
  $('body').on('click', '.js-create-meeting-session', function (e) {
    e.preventDefault();
    var $this = $(this);
    var item_id = $this.attr('data-item-id');
    var action = "/panel/meetings/".concat(item_id, "/add-session");
    $this.addClass('loadingbar primary').prop('disabled', true);
    var successHtml = "<div class=\"\">\n                <h3 class=\"font-16 text-center text-dark-blue\">".concat(sessionSuccessAdd, "</h3>\n                <p class=\"mt-5 font-14 text-gray\">").concat(youCanJoinTheSessionNowLang, "</p>\n            </div>");
    $.post(action, {}, function (result) {
      if (result && result.code === 200) {
        Swal.fire({
          icon: 'success',
          html: successHtml,
          showConfirmButton: false
        });
        setTimeout(function () {
          window.location.reload();
        }, 3000);
      }
    }).fail(function (err) {
      $this.removeClass('loadingbar primary').prop('disabled', false);
    });
  });
})(jQuery);
