/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "/";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 5);
/******/ })
/************************************************************************/
/******/ ({

/***/ "./resources/js/parts/instructor-finder.js":
/*!*************************************************!*\
  !*** ./resources/js/parts/instructor-finder.js ***!
  \*************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

function _createForOfIteratorHelper(o, allowArrayLike) { var it; if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = o[Symbol.iterator](); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

(function ($) {
  var instructorFinderMap;

  function handleMap() {
    var mapContainer = $('#instructorFinderMap');
    var mapOption = {
      dragging: true,
      zoomControl: true,
      scrollWheelZoom: false
    };
    var lat = mapContainer.attr('data-latitude');
    var lng = mapContainer.attr('data-longitude');
    var zoom = mapContainer.attr('data-zoom');
    instructorFinderMap = L.map('instructorFinderMap', mapOption).setView([lat, lng], zoom);
    L.tileLayer(leafletApiPath, {
      maxZoom: 18,
      minZoom: 3,
      tileSize: 512,
      zoomOffset: -1,
      attribution: '© <a target="_blank" rel="nofollow" href="http://www.openstreetmap.org/copyright">OpenStreetMap</a>'
    }).addTo(instructorFinderMap);
    var countryMarkers = [];
    var provinceMarkers = [];
    var cityMarkers = [];

    if (mapUsers && Array.isArray(mapUsers)) {
      var myMarkersGroup = L.markerClusterGroup({
        showCoverageOnHover: false
      });

      var _iterator = _createForOfIteratorHelper(mapUsers),
          _step;

      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var mapUser = _step.value;
          var marker = makeUserMarker(mapUser);
          myMarkersGroup.addLayer(marker);
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }

      instructorFinderMap.addLayer(myMarkersGroup);
    }

    feather.replace();
  }

  handleMap();

  function makeUserMarker(user) {
    var userMarker = L.divIcon({
      html: "<div class='marker-pin rounded-circle'><img src='" + user.avatar + "' class='img-cover rounded-circle' alt='" + user.full_name + "'/></div>",
      iconAnchor: [user.location[0] - 14, user.location[1] + 10],
      iconSize: [50, 50],
      className: 'rounded-circle bg-white border-0'
    });
    var marker = L.marker([user.location[0], user.location[1]], {
      icon: userMarker
    });
    marker.bindPopup(handleUserMapCardHtml(user), {
      className: 'map-instructor-card-popup'
    });
    return marker;
  }

  function getStarIconHtml() {
    return "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"24\" height=\"24\" viewBox=\"0 0 24 24\" fill=\"none\" stroke=\"currentColor\" stroke-width=\"2\" stroke-linecap=\"round\" stroke-linejoin=\"round\" class=\"feather feather-star\"><polygon points=\"12 2 15.09 8.26 22 9.27 17 14.14 18.18 21.02 12 17.77 5.82 21.02 7 14.14 2 9.27 8.91 8.26 12 2\"></polygon></svg>";
  }

  function handleUserRateHtml(rate) {
    var i = 5;
    var html = "<div class=\"stars-card d-flex align-items-center mt-10\">";

    while (--i >= 5 - rate) {
      html += "<i class=\"active\">".concat(getStarIconHtml(), "</i>");
    }

    while (i-- >= 0) {
      html += "<i class=\"\">".concat(getStarIconHtml(), "</i>");
    }

    html += "</div>";
    return html;
  }

  function handleUserMapCardHtml(user) {
    var _user$avatar, _user$full_name, _user$full_name2, _user$bio, _user$price;

    return "<div class=\"map-instructor-card p-10\">\n            <div class=\"d-flex align-items-center flex-column px-24 px-lg-32\">\n                <div class=\"map-instructor-card-avatar rounded-circle mt-10\">\n                    <img src=\"".concat((_user$avatar = user.avatar) !== null && _user$avatar !== void 0 ? _user$avatar : '', "\" class=\"img-cover rounded-circle\" alt=\"").concat((_user$full_name = user.full_name) !== null && _user$full_name !== void 0 ? _user$full_name : '', "\">\n                </div>\n\n                <h4 class=\"font-16 font-weight-bold mt-5\">").concat((_user$full_name2 = user.full_name) !== null && _user$full_name2 !== void 0 ? _user$full_name2 : '', "</h4>\n                <span class=\"d-block font-12 text-gray\">").concat((_user$bio = user.bio) !== null && _user$bio !== void 0 ? _user$bio : '', "</span>\n\n                ").concat(handleUserRateHtml(user.rate), "\n\n                <div class=\"mt-20\">\n                    <span class=\"text-primary font-20 font-weight-bold\">").concat(currency).concat((_user$price = user.price) !== null && _user$price !== void 0 ? _user$price : '', "</span>\n                    <span class=\"font-14 font-weight-500 text-gray\">/").concat(hourLang, "</span>\n                </div>\n            </div>\n\n            <a href=\"").concat(user.profileUrl, "\" class=\"btn btn-primary btn-sm btn-block mt-20 text-white\" target=\"_blank\">").concat(profileLang, "</a>\n        </div>");
  }

  $(document).ready(function () {
    var rangeTimeOut = undefined;

    function handleDoubleRange($el, item) {
      if ($el && $el.length) {
        var minLimit = $el.attr('data-minLimit');
        var maxLimit = $el.attr('data-maxLimit');
        var minTimeEl = $el.find('input[name="min_' + item + '"]');
        var maxTimeEl = $el.find('input[name="max_' + item + '"]');
        var minValue = minTimeEl.val();
        var maxValue = maxTimeEl.val();
        var range = $el.wRunner({
          type: 'range',
          limits: {
            minLimit: minLimit,
            maxLimit: maxLimit
          },
          rangeValue: {
            minValue: minValue,
            maxValue: maxValue
          },
          step: 1
        });
        range.onValueUpdate(function (values) {
          minTimeEl.val(values.minValue);
          maxTimeEl.val(values.maxValue);

          if (rangeTimeOut !== undefined) {
            clearTimeout(rangeTimeOut);
          }

          rangeTimeOut = setTimeout(function () {
            $('#filtersForm').trigger('submit');
          }, 1500);
        });
      }
    }

    handleDoubleRange($('#priceRange'), 'price');
    handleDoubleRange($('#instructorAgeRange'), 'age');
    handleDoubleRange($('#timeRangeInstructorPage'), 'time');
  });
  $('body').on('change', '#topFilters input,#topFilters select', function (e) {
    e.preventDefault();
    $('#filtersForm').trigger('submit');
  });
})(jQuery);

/***/ }),

/***/ 5:
/*!*******************************************************!*\
  !*** multi ./resources/js/parts/instructor-finder.js ***!
  \*******************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

module.exports = __webpack_require__(/*! /home/jack/projects/webinar/resources/js/parts/instructor-finder.js */"./resources/js/parts/instructor-finder.js");


/***/ })

/******/ });