<?php
    $socials = getSocials();
    if (!empty($socials) and count($socials)) {
        $socials = collect($socials)->sortBy('order')->toArray();
    }

    $footerColumns = getFooterColumns();
?>

<style>
    .shadow-effect {
        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        transition: box-shadow 0.3s ease-in-out;
    }

    .instructors-card-avatar img {
        max-width: 100%;
        height: auto;
    }
</style>

<section class="home-sections container">
    <div class="d-flex justify-content-between">
        <div>
            <h2 class="section-title">Our Supported Partners</h2>
            <p class="section-hint"># Empowering Collaborative &amp; Excellence</p>
        </div>
    </div>
    

    <!-- Add more items as needed -->

    <div class="row">
        <div class="col-6 col-md-2">
            <div class="shadow-effect">
                <div class="instructors-card d-flex flex-column align-items-center justify-content-center">
                    <div class="instructors-card-avatar d-flex flex-column align-items-center justify-content-center">
                        <img src="/store/partners/Flag_of_South_Sudan.png" alt="Flag of South Sudan" class="mx-auto d-block">
                    </div>
                </div>
            </div>
        </div>

        <div class="col-6 col-md-2">
            <div class="shadow-effect">
                <div class="instructors-card d-flex flex-column align-items-center justify-content-center">
                    <div class="instructors-card-avatar d-flex flex-column align-items-center justify-content-center">
                        <img src="/store/partners/Ministry-of-Trade.png" alt="Ministry of Trade" class="mx-auto d-block">
                    </div>
                </div>
            </div>
        </div>

        <div class="col-6 col-md-2">
            <div class="shadow-effect">
                <div class="instructors-card d-flex flex-column align-items-center justify-content-center">
                    <div class="instructors-card-avatar d-flex flex-column align-items-center justify-content-center">
                        <img src="/store/partners/dutch.png" alt="Dutch" class="mx-auto d-block">
                    </div>
                </div>
            </div>
        </div>

        <div class="col-6 col-md-2">
            <div class="shadow-effect">
                <div class="instructors-card d-flex flex-column align-items-center justify-content-center">
                    <div class="instructors-card-avatar d-flex flex-column align-items-center justify-content-center">
                        <img src="/store/partners/EIF.png" alt="EIF" class="mx-auto d-block">
                    </div>
                </div>
            </div>
        </div>

        <div class="col-6 col-md-2">
            <div class="shadow-effect">
                <div class="instructors-card d-flex flex-column align-items-center justify-content-center">
                    <div class="instructors-card-avatar d-flex flex-column align-items-center justify-content-center">
                        <img src="/store/partners/afdb.png" alt="AfDB" class="mx-auto d-block">
                    </div>
                </div>
            </div>
        </div>

        <div class="col-6 col-md-2">
            <div class="shadow-effect">
                <div class="instructors-card d-flex flex-column align-items-center justify-content-center">
                    <div class="instructors-card-avatar d-flex flex-column align-items-center justify-content-center">
                        <img src="/store/partners/UNDP-Logo-Blue-Large-Transparent-1.png" alt="UNDP Logo" class="mx-auto d-block">
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<footer class="footer bg-secondary position-relative user-select-none" id="footer">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class=" footer-subscribe d-block d-md-flex align-items-center justify-content-between">
                    <div class="flex-grow-1">
                        <strong><?php echo e(trans('footer.join_us_today')); ?></strong>
                        <span class="d-block mt-5 text-white"><?php echo e(trans('footer.subscribe_content')); ?></span>
                    </div>
                    <div class="subscribe-input bg-white p-10 flex-grow-1 mt-30 mt-md-0">
                        <form action="/newsletters" method="post">
                            <?php echo e(csrf_field()); ?>


                            <div class="form-group d-flex align-items-center m-0">
                                <div class="w-100">
                                    <input type="text" name="newsletter_email"
                                           class="form-control border-0 <?php $__errorArgs = ['newsletter_email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                           placeholder="<?php echo e(trans('footer.enter_email_here')); ?>"/>
                                    <?php $__errorArgs = ['newsletter_email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <button type="submit"
                                        class="btn btn-orange rounded-pill"><?php echo e(trans('footer.join')); ?></button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <?php
        $columns = ['first_column','second_column','third_column','forth_column'];
    ?>

    <div class="container">
        <div class="row">
            <?php $__currentLoopData = $columns; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $column): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-6 col-md-3">
                    <?php if(!empty($footerColumns[$column])): ?>
                        <?php if(!empty($footerColumns[$column]['title'])): ?>
                            <span class="header d-block font-weight-bold text-white"><?php echo e($footerColumns[$column]['title']); ?></span>
                        <?php endif; ?>

                        <?php if(!empty($footerColumns[$column]['value'])): ?>
                            <div class="">
                                <?php echo $footerColumns[$column]['value']; ?>

                            </div>
                        <?php endif; ?>
                    <?php endif; ?>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        </div>

        
    </div>

    <?php if(getOthersPersonalizationSettings('platform_phone_and_email_position') == 'footer'): ?>
        <div class="footer-copyright-card">
            <div class="container d-flex align-items-center justify-content-center py-15">
                <div class="font-14 text-white"><?php echo e(trans('update.platform_copyright_hint')); ?> <a href="/">
                        <img src="/store/1/bizex-logo.png" height="25px" class="thumbnail" alt="footer logo">
                    </a>
                </div>

                
            </div>
        </div>
    <?php endif; ?>

</footer>
<?php $__env->startPush('script'); ?>
    
<?php $__env->stopPush(); ?>
<?php /**PATH D:\laragon\www\lms\resources\views/web/default/includes/footer.blade.php ENDPATH**/ ?>